using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.ExerciseAvatar
{                                        
    public partial class FNewExerciseAvatar : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.ZB.N1200.ELearning.BL.BO.ExerciseAvatar _newExerciseAvatar = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        public FNewExerciseAvatar()
        {
            InitializeComponent();
        }

        public PI.ZB.N1200.ELearning.BL.BO.ExerciseAvatar NewExerciseAvatar
        {
            get 
            {
                if (_newExerciseAvatar == null)
                {
                    if ((_gComboBoxExerciseType.GetSelectedObjectValue() != null) && (_gComboBoxExerciseEvent.GetSelectedObjectValue() != null))
                    {
                        _newExerciseAvatar = BLZSBELearning.Avatar.Create(_gComboBoxExerciseType.GetSelectedEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.Types>(GM.N610.ELearning.BL.Dictionary.Exercise.Types.None), _gComboBoxExerciseEvent.GetSelectedEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType>(GM.N610.ELearning.BL.Dictionary.Exercise.EventType.None));
                    }
                }

                return _newExerciseAvatar; 
            }
        }

        public new void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            base.Initialize(ParentPlugIn, Environment);

            _gComboBoxExerciseType.SetDataSourceEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.Types>(PI.GM.N610.ELearning.BL.Dictionary.Text.ExerciseType);
            _gComboBoxExerciseEvent.SetDataSourceEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType>(PI.GM.N610.ELearning.BL.Dictionary.Text.ExerciseEvent);
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            bool _isValid = true;
            List<string> _listMessage = new List<string>();

            _gComboBoxExerciseEvent.ErrorText = null;
            _gComboBoxExerciseType.ErrorText = null;

            if (_gComboBoxExerciseType.GetSelectedObjectValue() == null)
            {
                _gComboBoxExerciseType.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelExerciseType.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelExerciseType.PlainText));
                _isValid = false;
            }

            if (_gComboBoxExerciseEvent.GetSelectedObjectValue() == null)
            {
                _gComboBoxExerciseEvent.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelExerciseEvent.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelExerciseEvent.PlainText));
                _isValid = false;
            }

            if (_isValid)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                PI.FM.N000.Base.WinForms.Controls.FDefaultMessage _dialog = new PI.FM.N000.Base.WinForms.Controls.FDefaultMessage();
                _dialog.SetMessage = _listMessage;
                _dialog.ShowDialog();
            }
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}